package editor;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import javax.imageio.ImageIO;

public class BackgroundFileData {
	
	private ArrayList<String> backgroundFileNames;
	
	public BackgroundFileData() {
		
		backgroundFileNames = new ArrayList<String>();
		
	}
	
	public void addFileName(String fileName) {
		backgroundFileNames.add(fileName);
	}
	
	/*public String validateAllFieldsSet() {
		
		StringBuffer returnValue = new StringBuffer();
		returnValue.append("Errors under the Background image data:\n");
		
		boolean noErrorsFound = true;
		
		if(backgroundFileNames == null || backgroundFileNames.isEmpty()) {
			return returnValue.toString() + "\t>>No background image data!\n";
		}
		
		File aFile = null;
		String tempFileName = null;
		
		for(int i = 0; i < backgroundFileNames.size(); i++) {
			
			tempFileName = backgroundFileNames.get(i);
			if(tempFileName == null || tempFileName.trim().length() == 0) {
				noErrorsFound = false;
				returnValue.append("\t>>At position " + (i + 1) + ", the image was blank!");
			} else {
				aFile = new File(tempFileName);
				
				if(!aFile.exists()) {
					noErrorsFound = false;
					returnValue.append("\t>>At position " + (i + 1) + ", the specified file could not be found:  \"" + tempFileName + "\"");
				}
			}
			
		}
		
		if(noErrorsFound)
			return null;
		else
			return returnValue.toString();
		
	}*/
	
	public void writeBackgroundFile(BufferedWriter out) throws IOException {
		
		out.write(Integer.toString(this.backgroundFileNames.size()));
		out.newLine();
		
		for(String s : backgroundFileNames) {
			out.write(s);
			out.newLine();
		}
		
	}
	
	public void readBackgroundFile(BufferedReader in) throws IOException {
		
		String sizeStr = in.readLine();
		
		int size = Integer.parseInt(sizeStr);
		
		if(backgroundFileNames == null) {
			backgroundFileNames = new ArrayList<String>();
		} else if(backgroundFileNames.size() > 0) {
			backgroundFileNames.clear();
		}
		
		for(int i = 0; i < size; i++) {
			backgroundFileNames.add(in.readLine());
		}
		
		
	}
	
	public ArrayList<String> getFilenameList() {
		return this.backgroundFileNames;
	}
	
	public String validateAllFieldsSet() {
		
		StringBuffer returnValue = new StringBuffer();
		returnValue.append("Errors under the Background data:\n");
		
		if(backgroundFileNames == null || backgroundFileNames.size() == 0) {
			
			returnValue.append("\t>>There were no frames for the background!");
			
			return returnValue.toString();
			
		}
		
		boolean noErrorsFound = true;
		
		String tempFilename = null;
		File tempFile = null;
		Image tempImage = null;
		
		for(int i = 0; i < backgroundFileNames.size(); i++) {
			tempImage = null;
			tempFilename = backgroundFileNames.get(i);
			if(tempFilename == null || tempFilename.length() <= 0) {
				returnValue.append("\t>>the " + convertToTH(i) + " frame has not been set.\n");
				noErrorsFound = false;
			} else {
				tempFile = new File(tempFilename);
				if(!tempFile.exists()) {
					returnValue.append("\t>>the " + convertToTH(i) + " frame has been set to a non-existent file:  \"" + tempFilename + "\".\n");
					noErrorsFound = false;
				} else {
					try {
						tempImage = ImageIO.read(tempFile);
						if(tempImage == null) {
							returnValue.append("\t>>the " + convertToTH(i) + " frame was not an image:  \"" + tempFilename + "\".\n");
							noErrorsFound = false;
						}
					} catch (IOException e) {
						returnValue.append("\t>>the " + convertToTH(i) + " frame received an error when the validation procedure attempted to open the image file \"" + tempFilename + "\".\n");
						noErrorsFound = false;
					}
				}
			}
		}
		
		if(noErrorsFound) {
			return null;
		} else {
			return returnValue.toString();
		}
		
	}
	
	public String convertToTH(int orig) {
		
		if(orig % 10 == 1) {
			if(orig % 100 == 11) {
				return orig + "th";
			} else {
				return orig + "st";
			}
		} else if(orig % 10 == 2) {
			if(orig % 100 == 12) {
				return orig + "th";
			} else {
				return orig + "nd";
			}
		} else if(orig % 10 == 3) {
			if(orig % 100 == 13) {
				return orig + "th";
			} else {
				return orig + "rd";
			}
		} else {
			return orig + "th";
		}
		
	}
	
}
